****************************** HILDA MERGE CODE ******************************** 
**************************** DATE: 13 APRIL 2017 ******************************* 
**************************** AUTHOR: FIONA PRICE ******************************* 
// Modifications by Kim Nguyen 2022

///This do file provides code to obtain unbalanced and balanced merged data files that contain the HILDA variables of interest for all persons in the HILDA Surveys/// 
///IMPORTANT: update the first section as directed but do not change any of the code in the other sections// 
///RUN WHOLE CODE, DO NOT RUN SECTIONS OF CODE OR LOCAL VARIABLES WILL DISAPPEAR/// 
///For assistance with the code, write to ER-MircoAnalysisAndData@rba.gov.au // 
///All changes to this program should be recorded in the version control section at the bottom// 

clear all 
set more off 
set maxvar 50000 

******************************************************************************** 
************************** 1. Parts to change ********************************** 
******************************************************************************** 

**set up local directories // update as necessary 
local readdatadir "Stata" 
local writedatadir "Input" 

**choose name for output files 
local unbalancedname "/Unbalanced" //the final term here is the name of your unbalanced output file. Keep the backslash 
local balancedname "/Balanced" ///the final term here is the name of your balanced output file. Keep the backslash 

**make sure local variables for waves are up-to-date 
local prefix a b c d e f g h i j k l m n o p q r s // add new wave to end as appropriate (a-wave 1; o-wave 15)
local waveno 19 // update this to latest wave number 
local wavepre s // update this to latest wave prefix 
local waves 19 // Number of X's should equal number of waves 

**choose HILDA variables you want to have in your main data file 
local varstokeep xwaveid hhid year hhpid hhrih hgage hgsex wave hhpxid hhpers hhtype hhfam hhmove tifdip tifdin edhigh1 hhtuh /// Keep this line, need these variables to identify household head 
hhwth hhwths hhwte hhwtes hhwthm /// Weights
hgsex hgdob hgyob hgage hhiage ancob anatsi anengf /// Demographics
anyoan anmigcn anengfn fmhsib fmnsib fmfsch fmmsch fmfpsq fmfhlq fmmpsq fmmhlq mrn ordfnum psb /// Background
mrcurr mrcdur ordf orcdur tcyng tcr tcr04 tcr514 tcr1524 tcr25 tcnr tcn04 tcn514 tcn1524 tcn25 hhd0_4 hhd5_9 hhd1014 hhd1524 hhadult ftcpg ftcppg ftpgwt ftpgtim hhfty tchave /// Family Status
iclike icexpct icn icniz icnha icny icno icibyhm /// Family planning
edagels edhists edtypes edhigh1 edfts edpsqfd /// Education
hglth helth /// Health
hhcompi hhcompf hhcomps /// Timing of Interview
hhstate hhpcode hhadst hhcd01 hhcd06 hhsla hhlga hhssd hhsd hhmsr hhsos hhra hhssa1 hhssa2 hhssa3 hhssa4 hhslga hhsgcc hhssos hhsra /// Geography
hhad hhec hhed hhsad hhsec hhsed hhura /// Neighbourhood
ehtse ehtjb ehtuj ehto esbrd esdtl hges esjtyp esempst jbn jbmo06 jbmo6s jbhruc jbmhruc jbhrcpr jbtprhr jbcmocc jbcasab jst jbmcnt jbmsvsr jbmwps jshjsa jsminws jsminhr jbmssec jomsf jbmsall /// Employment 
pjotrea pjljrea pjorea /// job loss variables
jbmplej jbmploj jbmpgj /// Employment Expectations
jomsf jbmssec jpjljrea jpmsemp jomwf /// Subjective indicators
rtage rtcomp rtyr rtstat rtcage rtmrea rtnwdmv rtnwdsh /// Retirement
wsfes bifip bifin oiinti oirntip oirntin oidvryi oifsupi oifppi tifpiip tifpiin bnfpeni bnfpari bnfapti tifefp tifefn tifdip tifdin tifeftp tifeftn tifditp tifditn /// Individual Income
hiwsfei hibifip hibifin hifinip hifinin hifppi hifpiip hifpiin hifpeni hifpari hifapti hifefp hifefn hifdip hifdin hifeftp hifeftn hifditp hifditn /// Household Income
wscei wscmei sscmi bncpeni bncpari hiwscei hiwscmi hicpeni hicpari /// Derived Wages
hwtbani hwsupei hweqini hwfini hwhmvai hwopvai hwtpvi hwbusvi hwcolli hwvechi hwnfii hwassei hwnwip hwnwin hwcaini hwsupri hwsupwi hwinsui hwtrusi crhave crpay fiprosp fiprbeg fiprbmr fiprbps fiprbwm fiprbuh fiprbfh fiprbwo fiemerf rjmbl hwccdti hwbusdi hwhmdti hwopdti hwobdti hwtpdi hwdebti hwothdt hwothdi hwhecdt crpebm crjmbl dtinva dtcara dtopla dthpa crymbl bajta fainvcv faoficv hwcaini hweqini hwhecdi fibfin fiemerf firisk firiska fisave fisav crhave crhavem crjcowe crjon crjowe crjpeb2 crycowe crpebm crymbl cryowe gaanday gaborr gacrit gafin gamore gaprob /// Debt repayments and financial stress
hsyr dodtyp hsbedrm hstenr hstenur hhmvehk hhmovek hsvalui hsprice hsloana mhrealb mhreasm mhreabn mhreaev mhreahn mhmth mhyr mhnyr mhaddk2 hsllord hsrnta hsrntf hsrntby hsbrd lshrcom lsmncom /// Housing
hsmguse hsmgpd hsmgowe hsmga hsmgi hsmgf hsmgtl2 hsmgsch hsmgfin hslnoth hslnowe hssluse hsslowe hssla hssli hsslf hssltl2 /// Mortgage repayment
hsrnti hxyalci hxyccfi hxycigi hxygrci hxyhlpi hxyhmri hxyholi hxymcfi hxymli hxymvfi hxymvri hxyoii hxypbti hxyphii hxyphmi hxytli hxyteli hxyutli hxywcfi hxycmpi hxyfrni hxyncri hxytvi hxyucri hxywgi /// Expenditures
hxygroc hxyalc hxycig hxypubt hxymeal hxymvf hxyphi hxyhmrn hxymvr hxyeduc hxyutil hxypbti hxymcf hxywcf hxyccf hxyteli hxyhol hxyoi hxyhltp hxyphrm hxyncar hxyucar hxycomp hxytvav hxyfurn /// 
rtiage1 rtagelr rtcpw65 rtsfrm rtmfmv rtmfsh rtmfso rtnwimv rtnwish rmhexpmt rmhexpyr /// Intentions and Expectations
losathl losateo losatfs losatsf losatlc losatyh losatnl losatft losat lsnwcht /// Satisfaction
rlosatnl rmhreabn rmhreahn rlslanh rlsland rlslatn rlslaat rlslahg rlslarl rlslats rlslaha rlslavd rlslabt rlslackn rlslawhn rlslatr rlslanga rlslansv rlsnwcht /// Neighbourhood
lemar lesep lercl leprg lebth leins leinf ledsc lertr lefrd lejob leprm lefni lefnw lemvd ledhm /// Life events
hxygroc hxyalc hxycig hxypubt hxymeal hxymvf hxymcf hxywcf hxyccf /// Expenditure household level
hxyteli hxyphi hxyoi hxyhltp hxyphrm hxyutil hxyhmrn hxymvr hxyeduc ///
hxygrci hxyalci hxycigi hxypbti hxymli hxymvfi hxyphii hxyhmri hxymvri ///
hxyedci hxyutli hxymcfi hxywcfi hxyccfi hxytlii hxyoii hxyhlpi hxyphmi ///
hxygrcf hxyalcf hxycigf hxypbtf hxymlf hxymvff hxyphif hxyutlf hxyhmrf ///
hxymvrf hxyedcf hxymcff hxywcff hxyccff hxytlif hxyoif hxyhlpf hxyphmf ///


///DO NOT MAKE ANY CHANGES TO THE FILE BEYOND THIS POINT/// 

******************************************************************************** 
************************* 2. Create unbalanced panel *************************** 
******************************************************************************** 

* Create temporary data files with selected variables for each wave 
local i = 0 
foreach w of local prefix { 
use "`readdatadir'/Combined_`w'190u" // Note: make sure file name matches the newest wave 

renpfix `w'      // Strip off wave prefix 
local i = `i'+1  // Increase (wave) counter by 1 
gen wave = `i'   // Create wave indicator 
gen year = 2000 + wave	// Create year variable 

if ("`varstokeep'"!="") { 
local tokeep	// empty to keep list 
foreach var of local varstokeep {	// loop over all selected variables 
capture confirm variable `var'	// check whether variable exists in current wave 
if (!_rc) local tokeep `tokeep' `var'	// mark for inclusion if variable exists 
} 
keep xwaveid wave year `tokeep'	// keep selected variables 
       } 

tempfile tempdata_`w' // Save temporary data file 
save "`tempdata_`w''" 
} 
label variable wave "Survey wave" 

* Append the temporary data files for each wave to create unbalanced panel 
clear 
foreach w of local prefix { 
append using "`tempdata_`w''" 
} 

order xwaveid wave 
sort  xwaveid wave 

tab wave // Check for any obvious errors in observations in each wave 

** Save the unbalanced data file you can then use for your analysis 
save "`writedatadir'`unbalancedname'", replace 

******************************************************************************** 
************************** 3. Create balanced panel **************************** 
******************************************************************************** 

// use unbalanced file and keep only those observed in all waves 
use "`readdatadir'/Master_`wavepre'`waveno'0u" 
keep xwaveid ivwptn yob dob 
merge 1:m xwaveid using "`writedatadir'`unbalancedname'", nogen 
keep if ivwptn=="`waves'" // keep persons responding in every wave; 
// there should be as many 'X's as there are waves 
order xwaveid wave 
sort  xwaveid wave 

tab wave // Check equal number of observations in ecah wave 

** Save the balanced data file you can then use for your analysis 
save "`writedatadir'`balancedname'", replace 

quietly{ 
******************************************************************************** 
************************** 4. Version control ********************************** 
******************************************************************************** 
*20170503 Original do-file created, Fiona Price 
*20170517 Error creating duplicates of Wave 15 fixed, Fiona Price and Iris Chan 
*20170524 Version control added, Adam Gorajek 
} 
